﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc.ModelBinding.Validation;
using Sf.Blazor.Dashboard.Example.ViewModels;

namespace Sf.Blazor.Dashboard.Example.Factories
{
    public class DashLayoutViewModelFactory
    {
        private static List<DashLayoutViewModel> _firstProfileCollection;
        private static List<DashLayoutViewModel> _secondProfileCollection;

        public static List<DashLayoutViewModel> FirstProfileCollection
        {
            get
            {
                if (_firstProfileCollection == null)
                {
                    _firstProfileCollection = new List<DashLayoutViewModel>
                    {
                        new DashLayoutViewModel
                        {
                            Value = "Profile 1 Layout 1",
                            Position = new DashLayoutPositionViewModel {Column = 0, Row = 0},
                            Size = new DashLayoutSizeViewModel
                            {
                                MaxSizeX = 3, MaxSizeY = 3, SizeX = 1, SizeY = 1
                            }
                        },
                        new DashLayoutViewModel
                        {
                            Value = "Profile 1 Layout 2",
                            Position = new DashLayoutPositionViewModel {Column = 1, Row = 0},
                            Size = new DashLayoutSizeViewModel
                            {
                                MaxSizeX = 3, MaxSizeY = 3, SizeX = 1, SizeY = 1
                            }
                        }
                    };
                }

                return _firstProfileCollection;
            }
        }

        public static List<DashLayoutViewModel> SecondProfileCollection
        {
            get
            {
                if (_secondProfileCollection == null)
                {
                    _secondProfileCollection = new List<DashLayoutViewModel>
                    {
                        new DashLayoutViewModel
                        {
                            Value = "Profile 2 Layout 1",
                            Position = new DashLayoutPositionViewModel {Column = 0, Row = 1},
                            Size = new DashLayoutSizeViewModel
                            {
                                MaxSizeX = 1, MaxSizeY = 1, SizeX = 1, SizeY = 1
                            }
                        },
                        new DashLayoutViewModel
                        {
                            Value = "Profile 2 Layout 2",
                            Position = new DashLayoutPositionViewModel {Column = 1, Row = 1},
                            Size = new DashLayoutSizeViewModel
                            {
                                MaxSizeX = 1, MaxSizeY = 1, SizeX = 1, SizeY = 1
                            }
                        }
                    };
                }

                return _secondProfileCollection;
            }
        }

        public static List<DashLayoutViewModel> CreateListForProfile(string profileName)
        {
            switch (profileName)
            {
                case "Profile 1":
                    return FirstProfileCollection;
                case "Profile 2":
                    return SecondProfileCollection;
                default:
                    throw new Exception();
            }
        }
    }
}